package de.mse.uebung6.aufgabe2;

public class Node<T extends Comparable<T>> {

   private T val;

   private Node<T> leftChild;
   private Node<T> rightChild;

   public Node(T val) {
      this.val = val;
      this.leftChild = null;
      this.rightChild = null;
   }

   public void insert(T val) {
      int diff = this.val.compareTo(val);
      if (diff == 0) {
         return;
      }

      if (diff < 0) {
         // Insert in left child
         if (leftChild == null) {
            leftChild = new Node<T>(val);
            return;
         }
         leftChild.insert(val);
      } else {
         // Insert in right child
         if (rightChild == null) {
            rightChild = new Node<T>(val);
            return;
         }
         rightChild.insert(val);
      }
   }
}
